﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using System.Windows.Forms;

namespace 電子文書回覧追跡ツール
{
    public class ApplicationSettings
    {
        XmlSerializer sr1 = null;
        StreamWriter stm1 = null;
        XmlSerializer sr2 = null;
        StreamReader stm2 = null;
        Encoding sjisEncoding =Encoding.GetEncoding("Shift_JIS");
        ApplicationSettings AppSetFromXML = null;

        public String xInsheet;
        public String xComment;
        public String xOutPath;
        public String[] xInGid = new String[18];
        public String[] xInPath = new String[18];

        internal void x構成セット(String p1, String p2, String p3)
        {
            xInsheet = p1;
            xComment = p2;
            xOutPath = p3;
        }
        //internal void x構成ゲット(String p1, String p2, TextBox[] p3, TextBox[] p4)
        //{
        //   p1 = xInsheet ;
        //   p2 = xOutPath ;
        //   p3 = xInGid ;   ここがうまく行かないので直接参照することにした
        //   p4 = xInPath ;
        //}
        internal bool x構成シリアル化()
        {
            try{
                sr1=new XmlSerializer(typeof(ApplicationSettings));
                stm1=new StreamWriter(new FileStream(System.AppDomain.CurrentDomain.BaseDirectory + @"\myApp.config",FileMode.Create),sjisEncoding);
                sr1.Serialize(stm1,this);
                return true;
            }
            catch(Exception ex){
                MessageBox.Show(ex.Message);
                return false;
            }
            finally{
                if(!(stm1==null))stm1.Close();
            }
        }
        internal bool x構成シリアル解除()
        {
            try
            {
                sr2 = new XmlSerializer(typeof(ApplicationSettings));
                FileInfo fi = new FileInfo(System.AppDomain.CurrentDomain.BaseDirectory + @"\myApp.config");
                if (fi.Exists)
                {
                    stm2 = new StreamReader(fi.FullName,sjisEncoding);
                    AppSetFromXML = (ApplicationSettings)sr2.Deserialize(stm2);
                    this.xInsheet = (String)AppSetFromXML.xInsheet;
                    this.xComment = (String)AppSetFromXML.xComment;
                    this.xOutPath = (String)AppSetFromXML.xOutPath;
                    this.xInGid = (String[])AppSetFromXML.xInGid;
                    this.xInPath = (String[])AppSetFromXML.xInPath;
                    return true;
                }
                else
                {
                    MessageBox.Show("構成ファイルが見当たりません");
                    return false;
                }

            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
                return false;

            }
            finally
            {
                if(!(stm2==null))stm2.Close();
            }
        }
    }
}
